package complex_operations;

import db_context.DbContext;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PathFinder {
    private static final PathFinder INSTANCE = new PathFinder();
    public static PathFinder getInstance() {
        return INSTANCE;
    }
    private PathFinder() {
    }

    public String recursive_sql(int start, int finish) throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * FROM path_finder(?, ?)")) {
            s.setInt(1, start);
            s.setInt(2, finish);
            try (ResultSet r = s.executeQuery()) {
                if(r.next()) {
                    return r.getArray(1).toString();
                }
            }
        }
        return null;
    }

    String just_show_function = "" +
            "create function path_finder(start integer, finish integer) returns integer[]\n" +
            "    language sql\n" +
            "as\n" +
            "$$\n" +
            "WITH RECURSIVE paths(src,dst,path) AS (\n" +
            "    SELECT e.loca_id, e.locb_id, ARRAY[e.loca_id,e.locb_id]\n" +
            "    FROM connections e where  e.loca_id = start and start != finish\n" +
            "    UNION\n" +
            "    SELECT p.src, e.locb_id, p.path || ARRAY[e.locb_id]\n" +
            "    FROM paths p JOIN connections e ON p.dst = e.loca_id AND e.locb_id != ALL(p.path)\n" +
            ")\n" +
            "SELECT path FROM paths where dst = finish limit 1;\n" +
            "$$;";
}
